import { StarXpandCommand } from "star-io10-web";

export class LabelSample21_For203dpiAnd300dpi_ProductLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // By setting the base print size of text to x1.5 for 300dpi,
            // you can print text at the same size as 203dpi.
            //.styleBaseMagnification(new BaseMagnificationParameter().setText(BaseMagnification.X1_5))
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 24.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    48.0,
                    24.0,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    22.0,
                    0.0,
                    22.0,
                    24.0,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    8.0,
                    22.0,
                    8.0,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    16.0,
                    22.0,
                    16.0,
                  ),
                )
                .styleHorizontalPositionTo(2.0)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .styleVerticalPositionTo(4.0)
                .actionPrintText("${code1}\n")
                .styleHorizontalPositionTo(2.0)
                .styleVerticalPositionTo(12.0)
                .actionPrintText("${code2}\n")
                .styleHorizontalPositionTo(2.0)
                .styleVerticalPositionTo(20.0)
                .actionPrintText("${code3}\n")
                .styleHorizontalPositionTo(26.0)
                .styleVerticalPositionTo(0.0)
                .actionPrintQRCode(
                  new StarXpandCommand.Printer.QRCodeParameter("${qrcode}")
                    .setCellSize(6)
                    .setLevel(StarXpandCommand.Printer.QRCodeLevel.Q)
                    .setModel(StarXpandCommand.Printer.QRCodeModel.Model2),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "code1" : "AA1107",
    "code2" : "BB5572",
    "code3" : "CC9937",
    "qrcode" : "AA1107BB5572CC9937"
}`,
    );
  }
}
